using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using TCX.Configuration;
using System.IO;

public partial class QueueMenu : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        String qdn = Request.Params.Get("qdn");
        XmlDocument doc = new XmlDocument();

        //PhoneSystem.ApplicationName = "VxmlGen";
        //PhoneSystem.Root.GetTenants();

        PrepareStartPage(doc,qdn);

        Response.Expires = 0;
        Response.Cache.SetNoStore();
        Response.BufferOutput = true;
        Response.AddHeader("Connection", "close");

        doc.Save(Response.OutputStream);
    }

    private void PrepareStartPage(XmlDocument doc,string qdn)
    {
        doc.Load(Request.PhysicalApplicationPath + "QueueMenu.vxml");

        string operDn = 
            PhoneSystem.Root.GetParameterByName("OPERATOR").Value;

        DN Qdn = PhoneSystem.Root.GetDNByNumber(qdn);
        if (Qdn != null && Qdn is TCX.Configuration.Queue)
        {
            TCX.Configuration.Queue queue = Qdn as TCX.Configuration.Queue;
            XmlNode prm = doc.SelectSingleNode("/vxml/form/field[@name='fldAnnouncement']/prompt");
            XmlNode prm2 = doc.SelectSingleNode("/vxml/form/field[@name='fldQ']/prompt");
            //timeount for annoncement
            XmlNode aud = prm2.FirstChild;
            if(queue.AnnounceQueuePosition==true&&queue.AnnouncementInterval>0)
            {
                XmlNode it = doc.SelectSingleNode("/vxml/var[@name='iterations']");
                it.Attributes["expr"].Value=((queue.MasterTimeout+queue.AnnouncementInterval-1)/queue.AnnouncementInterval).ToString();
                prm.Attributes["timeout"].Value = queue.AnnouncementInterval.ToString() + "s";
            }
            else
            {
                //setMaster timeout as wait time
                prm2.Attributes["timeout"].Value = queue.MasterTimeout.ToString() + "s";
            }
            if (queue.EnableIntro)
            {
                aud.Attributes["src"].Value = 
                    Path.Combine(Utils.GetPromptsPath(),queue.IntroFile);
            }
            String q_musicpath;
            if (queue.OnHoldFile != null && queue.OnHoldFile.Length > 0)
            {
                q_musicpath = Path.Combine(Utils.GetPromptsPath(), queue.OnHoldFile).Replace("\\", "/");
            }
            else
            {
                q_musicpath = Utils.GetPrompt("ONHOLD").Replace("\\", "/");
            }
            XmlNode var = doc.SelectSingleNode("/vxml/var[@name='q_music']");
            var.Attributes["expr"].Value = "'" + q_musicpath + "'";

            var = doc.SelectSingleNode("/vxml/var[@name='transf_dn']");

            if (queue.ForwardNoAnswer.To != DestinationType.None)
            {
                var.Attributes["expr"].Value = "'" +
                    (queue.ForwardNoAnswer.To == DestinationType.External ?
                    queue.ForwardNoAnswer.External : queue.ForwardNoAnswer.Internal.Number)
                    + "'";
            }

            if (queue.ForwardNoAnswer.To == DestinationType.VoiceMail)
            {
                var = doc.SelectSingleNode("/vxml/var[@name='transf_param']");
                var.Attributes["expr"].Value = "'vmail'";
            }

            //var = doc.SelectSingleNode("/vxml/var[@name='oper_dn']");
            //var.Attributes["expr"].Value = "'" + operDn + "'";
        }
    }
}
