using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.IO;

public partial class SaveVmail : System.Web.UI.Page
{
    public static String basePath = @"C:\Program Files\3CX PhoneSystem\Data\Ivr\Voicemail\Extensions\";

    protected void Page_Load(object sender, EventArgs e)
    {/*
        int size = Request.InputStream.Length;
        byte[] buffer = new byte[size];
        Request.InputStream.Read(buffer,0,size);
        */
        basePath = Utils.GetVoicemailPath();
        basePath = Path.GetFullPath(basePath + @"\Extensions\");

        XmlDocument doc;

        String caller = Request.Params.Get("CallerNum");
        String caller_name = Request.Params.Get("CallerName");
        String ext = Request.Params["VMBox"];
        String dur = Request.Params["msg_duration"];

        if (caller == null)
            caller = "anon";

        String err_msg = null;

        try
        {
            String path = basePath + ext;
            System.IO.Directory.CreateDirectory(path);

            String dt = String.Format("{0:yyyy}{0:MM}{0:dd}{0:HH}{0:mm}{0:ss}",
                DateTime.UtcNow);
            String filename = "vmail_" + caller + "_" + ext + "_" + dt;

            HttpPostedFile f = Request.Files.Get("msg");
            f.SaveAs(path + "\\" + filename + ".wav");

            doc = new XmlDocument();
            XmlDeclaration d = doc.CreateXmlDeclaration("1.0", "utf-8", null);
            doc.InsertBefore(d, doc.DocumentElement);
            XmlNode vmsg = doc.CreateElement("VOICEMSG");
            doc.AppendChild(vmsg);

            XmlNode file = doc.CreateElement("FILE");
            vmsg.AppendChild(file);
            if (dur != null)
                Utils.AddAttr(file, "DURATION", dur);
            Utils.AddAttr(file, "CALLER", caller);
            Utils.AddAttr(file, "CALLER_NAME", caller_name);
            file.InnerText = filename + ".wav";

            XmlNode crt = doc.CreateElement("CREATED");
            vmsg.AppendChild(crt);
            crt.InnerText =
                String.Format(
                    "{0:yyyy}{0:MM}{0:dd}{0:HH}{0:mm}{0:ss}.{0:ff}",
                    DateTime.UtcNow);

            XmlNode flags = doc.CreateElement("FLAGS");
            vmsg.AppendChild(flags);
            flags.InnerText = "0";

            doc.Save(path + "\\" + filename + ".xml");
        }
        catch(Exception ex)
        {
            err_msg = ex.Message;
        }

        doc = new XmlDocument();
        XmlNode vxml = doc.CreateElement("vxml");
        doc.AppendChild(vxml);

        Utils.AddAttr(vxml, "version", "2.0");
        Utils.AddAttr(vxml, "application", "root.vxml");

        XmlNode form = doc.CreateElement("form");
        vxml.AppendChild(form);

        XmlNode blk = doc.CreateElement("block");
        form.AppendChild(blk);

        String prompt = "MSGSVD";
        if (err_msg != null)
        {
            XmlNode log = doc.CreateElement("log");
            blk.AppendChild(log);
            log.InnerText = err_msg;
            prompt = "MSGSAVFAIL";
        }

        XmlNode prm = doc.CreateElement("prompt");
        blk.AppendChild(prm);
        Utils.AddAttr(prm, "bargein", "false");
        Utils.AddAttr(prm, "timeout", "1ms");

        XmlNode audio = doc.CreateElement("audio");
        prm.AppendChild(audio);

        Utils.AddAttr(audio, "src", "GetPrompt.aspx?id=" + prompt);

        XmlNode ret = doc.CreateElement("return");
        blk.AppendChild(ret);

        Response.Buffer = true;
        Response.BufferOutput = true;
        Response.Expires = 0;
        Response.Cache.SetNoStore();
        Response.Clear();
        //Response.AddHeader("Connection", "close");

        doc.Save(Response.OutputStream);
        doc.Save(Console.Out);
        //Response.Flush();
    }
}
