﻿<%@ Page Title="<%$Resources:WallBoard, WallBoard_Title%>" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true"
    CodeBehind="Default.aspx.cs" Inherits="WallBoard._Default" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="Scripts/jquery-1.4.1.min.js" type="text/javascript"></script>
    <script src="Scripts/json2.js" type="text/javascript"></script>
    <script src="Scripts/jquery.slws.js" type="text/javascript"></script>  
    <script src="Scripts/h5utils.js" type="text/javascript"></script>
    <script src="Scripts/jquery.blockUI.js" type="text/javascript"></script>
    <script src="Scripts/Silverlight.js" type="text/javascript"></script>
<%--    <script type="text/javascript" src="Scripts/swfobject.js"></script>
    <script type="text/javascript" src="Scripts/web_socket.js"></script>
--%>
    <script type="text/javascript">

        // WebSocket object
        var ws;
        // Display current client status
        var state;
        // Reconnect interval (seconds)
        var reconnectInterval = <%= ReconnectInterval %>;
        // WebSocket is natively supported
        var nativeSocketSupport;
        // Type of established connection: NATIVE or SILVERLIGHT
        var connectionType;
        // Current queue object
        var queue;
        // Message board
        var messageBoard;
        // Debug mode
        var debugMode = "<%= DebugMode %>";
        // Set URL of your WebSocketMain.swf here:
        //var WEB_SOCKET_SWF_LOCATION = "Assets/Plugins/WebSocketMain.swf";
        // Set this to dump debug message from Flash to console.log:
        //var WEB_SOCKET_DEBUG = true;

        // Connect to WebSocket server
        function connectSocketServer() {
            try {

                if (ws === undefined || ws.readyState === undefined || ws.readyState > 1) {

                    state.innerHTML = "Connecting to server ...";
                    logMessageBoard("Connecting to server ...");

                    if (nativeSocketSupport != null) {
                        connectionType = "NATIVE";
                        // Create a new web socket and connect
                        ws = new window[nativeSocketSupport]('ws://<%= Request.Url.Host %>:<%= WebSocketPort %>/wallboard');
                        //ws = new WebSocket('ws://<%= Request.Url.Host %>:<%= WebSocketPort %>/wallboard');
                    }
                    else {
                        connectionType = "SILVERLIGHT";
                        // Create a Silverlight web socket
                        ws = new WebSocketDraft('ws://<%= Request.Url.Host %>:<%= WebSocketSLPort %>/wallboard');
                        
//                        connectionType = "FLASH";
//                        // Create a Flash web socket
//                        ws = new WebSocket('ws://<%= Request.Url.Host %>:<%= WebSocketPort %>');
                    }

                    // Called when the connection is established
                    ws.onopen = function () {
                        setCurrentState('success', "Connection open " + connectionType);
                        logMessageBoard("Connection open " + connectionType);

                        // Send selected queue as a message to fill IE session cookies problem
                        sendSelectedQueue();

                        // Unblock UI
                        $.unblockUI();
                    };

                    // Called when the connection is closed
                    ws.onclose = function () {
                        setCurrentState('fail', "Connection closed");
                        logMessageBoard("Connection closed");

                        // Unblock UI
                        $.unblockUI();
                    }

                    // Called when data is coming from the server
                    ws.onmessage = function (event) {
                        try {
                            message = JSON.parse(event.data);
                            if (message != undefined) 
                            {
                                switch (message.key) 
                                {
                                    case "QueueDataUpdate":
                                        var isCCE = "<%=IsCCE%>";
                                        if (isCCE == "True")
                                            updateQueueData(JSON.parse(message.value));
                                        break;
                                    case "QueueUpdate":
                                        updateQueue(JSON.parse(message.value));
                                        break;
//                                    case "KeepAlive":
//                                        logMessageBoard("Message from server: " + message.value);
//                                        break;
                                }
                            }
                        }
                        catch (err) {
                            logMessageBoard("Exception: " + err.message);
                            reopenWebSocket();
                        }
                    };

                    // Called when an error occurred
                    ws.onerror = function (event) {
                        logMessageBoard("Error:" + event.data);

                        // Unblock UI
                        $.unblockUI();
                    };
                }
                else {
                    setCurrentState('success', "Connection open " + connectionType);
                    logMessageBoard("Connection open " + connectionType);
                }
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        // Client message used to send messages to the server
        function WebSocketMessage() {
            this.key = "";
            this.value = "";
        }

        // Send client message to the server
        function sendMessage(message) {
            try {
                if (ws)
                    ws.send(message);
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        // Send selected queue as a message to fix IE session cookies problem
        function sendSelectedQueue() {
            try {
                var queueCookie = getCookie("QueueID");
                if (queueCookie != null) {
                    var message = new WebSocketMessage();
                    message.key = "QueueID";
                    message.value = queueCookie;
                    var result = JSON.stringify(message);
                    if(result != undefined)
                        sendMessage(result);
                }
            }
            catch (err) {
                logMessageBoard("Exception:" + err);
            }
        }

        // Retrieve specified cookie value from browser
        function getCookie(cookie_name) {
            try {
                var results = document.cookie.match('(^|;) ?' + cookie_name + '=([^;]*)(;|$)');
                if (results)
                    return (unescape(results[2]));
                else
                    return null;
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        function setCookie(c_name, value, exdays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + exdays);
            var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
            document.cookie = c_name + "=" + c_value;
        }

        // Update queue information when a queue is updated from managemet
        function updateQueue(queue) {

            try {
                // Set cookie
                setCookie("QueueName", queue.Name, 365);
                // Set queue name
                $("#QueueName").text(queue.Name);
                // Set page title
                document.title = "<% Response.Write(Resources.WallBoard.Queue_Title); %>" + " " + queue.Name + " " + "(" + queue.Number + ")";
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        // Update queue statistics with new values
        function updateQueueData(queue) {

            try {
                // CallsWaiting
                if (queue.CallsWaiting.IsVisible) {
                    var callsWaitingTd = $('#' + queue.CallsWaiting.Name);
                    var callsWaitingSpan = $(callsWaitingTd).find('span');
                    $(callsWaitingSpan).text(queue.CallsWaiting.Value);
                    $(callsWaitingSpan).css("color", getThresholdColor(queue.CallsWaiting));
                }
                // AverageWaitingTime
                if (queue.AverageWaitingTime.IsVisible) {
                    var averageWaitingTimeTd = $('#' + queue.AverageWaitingTime.Name);
                    var averageWaitingTimeSpan = $(averageWaitingTimeTd).find('span');
                    $(averageWaitingTimeSpan).text(getFormattedTimeValue(parseInt(queue.AverageWaitingTime.Value)));
                    $(averageWaitingTimeSpan).css("color", getThresholdColor(queue.AverageWaitingTime));
                }
                // TotalCalls
                if (queue.TotalCalls.IsVisible) {
                    var totalCallsTd = $('#' + queue.TotalCalls.Name);
                    var totalCallsSpan = $(totalCallsTd).find('span');
                    $(totalCallsSpan).text(queue.TotalCalls.Value);
                    $(totalCallsSpan).css("color", getThresholdColor(queue.TotalCalls));
                }
                // Answered calls
                if (queue.Answered.IsVisible) {
                    var answeredTd = $('#' + queue.Answered.Name);
                    var answeredSpan = $(answeredTd).find('span');
                    $(answeredSpan).text(queue.Answered.Value);
                    $(answeredSpan).css("color", getThresholdColor(queue.Answered));
                }
                // Unanswered
                if (queue.Unanswered.IsVisible) {
                    var anansweredTd = $('#' + queue.Unanswered.Name);
                    var anansweredSpan = $(anansweredTd).find('span');
                    $(anansweredSpan).text(queue.Unanswered.Value);
                    $(anansweredSpan).css("color", getThresholdColor(queue.Unanswered));
                }

                // CallsInPoll
                if (queue.CallsInPoll.IsVisible) {
                    var callsInPollTd = $('#' + queue.CallsInPoll.Name);
                    var callsInPollSpan = $(callsInPollTd).find('span');
                    $(callsInPollSpan).text(queue.CallsInPoll.Value);
                    $(callsInPollSpan).css("color", getThresholdColor(queue.CallsInPoll));
                }
                // CallsServicingNow
                if (queue.CallsServicingNow.IsVisible) {
                    var callsServicingNowTd = $('#' + queue.CallsServicingNow.Name);
                    var callsServicingNowSpan = $(callsServicingNowTd).find('span');
                    $(callsServicingNowSpan).text(queue.CallsServicingNow.Value);
                    $(callsServicingNowSpan).css("color", getThresholdColor(queue.CallsServicingNow));
                }
                // DroppedInWait
                if (queue.DroppedInWait.IsVisible) {
                    var droppedInWaitTd = $('#' + queue.DroppedInWait.Name);
                    var droppedInWaitSpan = $(droppedInWaitTd).find('span');
                    $(droppedInWaitSpan).text(queue.DroppedInWait.Value);
                    $(droppedInWaitSpan).css("color", getThresholdColor(queue.DroppedInWait));
                }
                // ReqCallBacks
                if (queue.ReqCallBacks.IsVisible) {
                    var reqCallBacksTd = $('#' + queue.ReqCallBacks.Name);
                    var reqCallBacksSpan = $(reqCallBacksTd).find('span');
                    $(reqCallBacksSpan).text(queue.ReqCallBacks.Value);
                    $(reqCallBacksSpan).css("color", getThresholdColor(queue.ReqCallBacks));
                }
                // DroppedInPoll
                if (queue.DroppedInPoll.IsVisible) {
                    var callsDroppedInPollTd = $('#' + queue.DroppedInPoll.Name);
                    var callsDroppedInPollSpan = $(callsDroppedInPollTd).find('span');
                    $(callsDroppedInPollSpan).text(queue.DroppedInPoll.Value);
                    $(callsDroppedInPollSpan).css("color", getThresholdColor(queue.DroppedInPoll));
                }
                // CallsExpired
                if (queue.CallsExpired.IsVisible) {
                    var callsExpiredTd = $('#' + queue.CallsExpired.Name);
                    var callsExpiredSpan = $(callsExpiredTd).find('span');
                    $(callsExpiredSpan).text(queue.CallsExpired.Value);
                    $(callsExpiredSpan).css("color", getThresholdColor(queue.CallsExpired));
                }
                // DroppedByQMCalls
                if (queue.DroppedByQMCalls.IsVisible) {
                    var callsDroppedByQMTd = $('#' + queue.DroppedByQMCalls.Name);
                    var callsDroppedByQMSpan = $(callsDroppedByQMTd).find('span');
                    $(callsDroppedByQMSpan).text(queue.DroppedByQMCalls.Value);
                    $(callsDroppedByQMSpan).css("color", getThresholdColor(queue.DroppedByQMCalls));
                }
                // TotalTalkTime
                if (queue.TotalTalkTime.IsVisible) {
                    var totalTalkTimeTd = $('#' + queue.TotalTalkTime.Name);
                    var totalTalkTimeSpan = $(totalTalkTimeTd).find('span');
                    $(totalTalkTimeSpan).text(getFormattedTimeValue(parseInt(queue.TotalTalkTime.Value)));
                    $(totalTalkTimeSpan).css("color", getThresholdColor(queue.TotalTalkTime));
                }
                // LongestWaitTime
                if (queue.LongestWaitTime.IsVisible) {
                    var longestWaitTimeTd = $('#' + queue.LongestWaitTime.Name);
                    var longestWaitTimeSpan = $(longestWaitTimeTd).find('span');
                    $(longestWaitTimeSpan).text(getFormattedTimeValue(parseInt(queue.LongestWaitTime.Value)));
                    $(longestWaitTimeSpan).css("color", getThresholdColor(queue.LongestWaitTime));
                }
                // AvTalkTime
                if (queue.AvTalkTime.IsVisible) {
                    var avTalkTimeTd = $('#' + queue.AvTalkTime.Name);
                    var avTalkTimeSpan = $(avTalkTimeTd).find('span');
                    $(avTalkTimeSpan).text(getFormattedTimeValue(parseInt(queue.AvTalkTime.Value)));
                    $(avTalkTimeSpan).css("color", getThresholdColor(queue.AvTalkTime));
                }
                // AbandonRate
                if (queue.AbandonRate.IsVisible) {
                    var abandonRateTd = $('#' + queue.AbandonRate.Name);
                    var abandonRateSpan = $(abandonRateTd).find('span');
                    $(abandonRateSpan).text(queue.AbandonRate.Value);
                    $(abandonRateSpan).css("color", getThresholdColor(queue.AbandonRate));
                }
                // TotalCallsReachedMaxTime
                if (queue.TotalCallsReachedMaxTime.IsVisible) {
                    var totalCallsReachedMaxTimeTd = $('#' + queue.TotalCallsReachedMaxTime.Name);
                    var totalCallsReachedMaxTimeSpan = $(totalCallsReachedMaxTimeTd).find('span');
                    $(totalCallsReachedMaxTimeSpan).text(queue.TotalCallsReachedMaxTime.Value);
                    $(totalCallsReachedMaxTimeSpan).css("color", getThresholdColor(queue.TotalCallsReachedMaxTime));
                }
                // TotalUserRequestedEnd
                if (queue.TotalUserRequestedEnd.IsVisible) {
                    var totalUserRequestedEndTd = $('#' + queue.TotalUserRequestedEnd.Name);
                    var totalUserRequestedEndSpan = $(totalUserRequestedEndTd).find('span');
                    $(totalUserRequestedEndSpan).text(queue.TotalUserRequestedEnd.Value);
                    $(totalUserRequestedEndSpan).css("color", getThresholdColor(queue.TotalUserRequestedEnd));
                }
                // TotalTransfersFailed
                if (queue.TotalTransfersFailed.IsVisible) {
                    var totalTransfersFailedTd = $('#' + queue.TotalTransfersFailed.Name);
                    var totalTransfersFailedSpan = $(totalTransfersFailedTd).find('span');
                    $(totalTransfersFailedSpan).text(queue.TotalTransfersFailed.Value);
                    $(totalTransfersFailedSpan).css("color", getThresholdColor(queue.TotalTransfersFailed));
                }
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        // Retrieve threshold color based on the specified queue property
        function getThresholdColor(queueProperty) {
            if(queueProperty.Value != 0)
            {
                var numThresholds = queueProperty.Threshold.length;
                for (var i in queueProperty.Threshold) {
                    var threshold = queueProperty.Threshold[i];
                    if (queueProperty.Value <= threshold.Value)
                        return threshold.Color;
                    else {
                        // Use the last threshold if value exeeds max threshold
                        if (i == numThresholds - 1) {
                            return threshold.Color;
                        }
                    }
                }
            }
            else
            {
                // White CSS color
                return "White";
            }
        }

        function getFormattedTimeValue(value) {
            // Seconds
            var formattedTime = value;
            if(value > 0) {
                hours = parseInt(value / (3600));
                minutes = parseInt((value % (3600)) / (60));
                seconds = ((value % (3600)) % (60));

                if(value < 60) {
                    // Seconds
                    formattedTime = formattedTime + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Seconds); %>";
                }
                else if(value >= 60 && value < 3600) {
                    // Minutes:Seconds
                    formattedTime = minutes + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Minutes); %>" + " " + seconds + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Seconds); %>"; 
                }
                else if(value >= 3600) {
                    // Hours:Minutes:Seconds
                    formattedTime = hours + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Hours); %>" + " " + minutes + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Minutes); %>" + " " + seconds + " " + "<% Response.Write(Resources.WallBoard.Queue_Time_Seconds); %>";
                }
            }
            
            return formattedTime;
        }

        // Update current time each second
        window.setInterval(function () {
            var date = new Date();
            $("#Time").text(date.toLocaleTimeString());
        }, 1000);

        // Check connection status each "reconnectInterval" seconds. If connection not valid anymore, try to reconnect.
        window.setInterval(function () {
            if (ws != undefined && ws.readyState > 1) {
                setTimeout(function () {
                    reopenWebSocket();
                }, 250);
            }
        }, reconnectInterval * 1000);

        // Called when browser size is changing. Resize client content to fit all available space.
        function resizeFrame() {
            try {
                 var h = $(window).height();
                 var w = $(window).width();

                 //Update QueueTable height to fill the whole page
                 $('#QueueTable').css("height", (h - 20) + "px");
             }
             catch (err) {
                 logMessageBoard("Exception: " + err);
             }
        }

        // Add event to listen for browser resize
        jQuery.event.add(window, "resize", resizeFrame);

        // Block user interface
        function blockUserInterface() {
            try {
                $.blockUI({
                    message: '<img src="Assets/Images/ajax-loader.gif" vertical-align:middle /> Connecting...',
                    css: {
                        border: 'none',
                        padding: '15px',
                        backgroundColor: '#202020',
                        '-webkit-border-radius': '10px',
                        '-moz-border-radius': '10px',
                        opacity: '1',
                        color: '#fff',
                        fontSize: "3em",
                        fontWeight: "bold"
                    }
                });
            }
            catch (err) {
                logMessageBoard("Exception: " + err);
            }
        }

        // Reopen WebSocket connection
        function reopenWebSocket() {
            if (ws != undefined && ws.readyState > 1) {
                ws.close();

                // Access a dummy page before trying to reconnect to force Global.asax reinitialize.
                $.ajax({
                    type: "POST",
                    url: "Reconnect.aspx",
                    data: "Ping",
                    cache: false,
                    success: function (msg) {
                        // Debug only
                        //$('#messageBoard').append("Reconnect.aspx says: " + msg + "<br/>");
                    }
                });

                setTimeout(function () {
                    connectSocketServer();
                }, 250);
            }
        }

        function logMessageBoard(message) {
            if(debugMode == "True")
            {
                var date = new Date();
                $('#messageBoard').append('<span class="messageValue">' + message + "</span>" + 
                '<span class="messageDate">' + "&nbsp;" + date.toLocaleString() + "</span>" + "<br/>");
            }
        }

        function setCurrentState(className, message) {
            state.className = className;
            state.innerHTML = message;
        }

        // Open WebSocket connection
        function openWebSocket() {

            try {
                // Check for native WebSocket support. Also do a special check for Mozilla WebSocket.
                nativeSocketSupport = "MozWebSocket" in window ? 'MozWebSocket' : ("WebSocket" in window ? 'WebSocket' : null);
            
                if (nativeSocketSupport == null) {

                    // Detect if Silverlight plugin is installed
                    var isSLInstalled = Silverlight.isInstalled("1.0");
                    if (isSLInstalled) {
                        $.slws.ready(function () {
                            if (window.WebSocketDraft === undefined) {
                                setCurrentState("fail", "Sockets not supported");
                                logMessageBoard("Sockets not supported" + "<br/>");
                            }
                            else {
                                // Open connection
                                connectSocketServer();
                            }
                        })
                    }
                    else {
                        // Unblock UI
                        $.unblockUI();
                    }
                }
                else {
                    // Open connection
                    connectSocketServer();
                }
            }
            catch (err) {
                logMessageBoard("Exception: " + err + "<br/>");
            }
        }

        function updateInitialLayout() {

            try {
                // Initialize state variable used to display current client status
                state = document.getElementById('status');

                // If Not debug mode, hide log
                if (!(debugMode == "True")) {
                    $('#messageBoardRow').css("display", "none");
                }

                // Set current date
                var date = new Date();
                $("#Date").text(date.toLocaleDateString());
            }
            catch (err) {
                logMessageBoard("Exception: " + err + "<br/>");
            }
        }

        // Page was successfully loaded
        $(document).ready(function () {

            // Initialize initial layout stuff
            updateInitialLayout();

            // Block user interface until connection is open or closed
            blockUserInterface();

            // Try to open WebSocket connection
            openWebSocket();

            // Resize client content to fit all available space
            resizeFrame();
        });

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
      
        <table id="QueueTable" class="queueTable" align="center" cellspacing="0">

            <tr>
                <td class="leftMenuHeader" align="left">
                    <p id="status" class="fail"></p>
                </td>
                <td class="rightMenuHeader" align="right">
                    <asp:LoginView ID="LoginView1" runat="server" EnableViewState="false">
                        <AnonymousTemplate>
                            [ <a href="~/Account/Login.aspx" ID="HeadLoginStatus" runat="server">Log In</a> ]
                        </AnonymousTemplate>
                        <LoggedInTemplate>
                            <asp:Literal ID="CallsWaitingLiteral" runat="server" Text="<%$Resources:WallBoard, Login_Welcome%>"/> 
                            <span class="bold"><asp:LoginName ID="HeadLoginName" runat="server" /></span>!
                            [ <asp:LoginStatus ID="HeadLoginStatus" runat="server" LogoutAction="Redirect" LogoutText="<%$Resources:WallBoard, Logout_Logout%>" LogoutPageUrl="~/"/> ]
                        </LoggedInTemplate>
                    </asp:LoginView>
                </td>
            </tr>

            <tr>
                <td class="leftQueueHeader">
                    <p class="dateTime">
                        <span id="Date" class="captionDateLabel"></span><br />
                        <span id="Time" class="captionTimeLabel"></span>
                    </p>
                </td>
                <td class="rightQueueHeader" align="center">
                    <span id="QueueName" class="captionQueueName"><%= queue.Name %></span>
                </td>
            </tr>

            <tr <% if(!queue.CallsInPoll.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P1" class="captionLabel">
                        <asp:Literal ID="Literal5" runat="server" Text="<%$Resources:WallBoard, Queue_CallsInPoll%>"/>
                    </p>
                </td>
                <td ID="CallsInPoll" align="center">
                    <asp:Label ID="Label6" class="callsInPoll" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
			
			 <tr <% if(!queue.CallsServicingNow.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P2" class="captionLabel">
                        <asp:Literal ID="Literal6" runat="server" Text="<%$Resources:WallBoard, Queue_CallsServicingNow%>"/>
                    </p>
                </td>
                <td ID="CallsServicingNow" align="center">
                    <asp:Label ID="Label7" class="callsServicingNow" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
			
			<tr <% if(!queue.CallsWaiting.IsVisible) Response.Write("style=display:none");%>>
                <td >
                    <p id="CallsWaitingLabel" class="captionLabel">
                        <asp:Literal ID="CallsWaitingLiteral" runat="server" Text="<%$Resources:WallBoard, Queue_CallsWaiting%>"/>
                    </p>
                </td>
                <td ID="CallsWaiting" align="center">
                    <asp:Label ID="Label1" class="callsWaiting" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>

            <tr <% if(!queue.AverageWaitingTime.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="AverageWaitingTimeLabel" class="captionLabel">
                        <asp:Literal ID="Literal1" runat="server" Text="<%$Resources:WallBoard, Queue_AverageWaitingTime%>"/>
                    </p>
                </td>
                <td ID="AverageWaitingTime" align="center">
                    <asp:Label ID="Label2" class="averageWaitingTime" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>

            <tr <% if(!queue.TotalCalls.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="TotalCallsLabel" class="captionLabel">
                        <asp:Literal ID="Literal2" runat="server" Text="<%$Resources:WallBoard, Queue_TotalCalls%>"/>
                    </p>
                </td>
                <td ID="TotalCalls" align="center">
                    <asp:Label ID="Label3" class="totalCalls" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
        
            <tr <% if(!queue.Answered.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="AnsweredLabel" class="captionLabel">
                        <asp:Literal ID="Literal3" runat="server" Text="<%$Resources:WallBoard, Queue_Answered%>"/>
                    </p>
                </td>
                <td ID="Answered" align="center">
                    <asp:Label ID="Label4" class="answered" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>

            <tr <% if(!queue.Unanswered.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="UnansweredLabel" class="captionLabel">
                        <asp:Literal ID="Literal4" runat="server" Text="<%$Resources:WallBoard, Queue_Unanswered%>"/>
                    </p>
                </td>
                <td ID="Unanswered" align="center">
                    <asp:Label ID="Label5" class="unanswered" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>

            <tr <% if(!queue.DroppedInWait.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P3" class="captionLabel">
                        <asp:Literal ID="Literal7" runat="server" Text="<%$Resources:WallBoard, Queue_DroppedInWait%>"/>
                    </p>
                </td>
                <td ID="DroppedInWait" align="center">
                    <asp:Label ID="Label8" class="droppedInWait" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.ReqCallBacks.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P4" class="captionLabel">
                        <asp:Literal ID="Literal8" runat="server" Text="<%$Resources:WallBoard, Queue_ReqCallBack%>"/>
                    </p>
                </td>
                <td ID="ReqCallBacks" align="center">
                    <asp:Label ID="Label9" class="reqCallBacks" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.DroppedInPoll.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P5" class="captionLabel">
                        <asp:Literal ID="Literal9" runat="server" Text="<%$Resources:WallBoard, Queue_DroppedInPoll%>"/>
                    </p>
                </td>
                <td ID="DroppedInPoll" align="center">
                    <asp:Label ID="Label10" class="droppedInPoll" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.CallsExpired.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P6" class="captionLabel">
                        <asp:Literal ID="Literal10" runat="server" Text="<%$Resources:WallBoard, Queue_CallsExpired%>"/>
                    </p>
                </td>
                <td ID="CallsExpired" align="center">
                    <asp:Label ID="Label11" class="callsExpired" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.DroppedByQMCalls.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P7" class="captionLabel">
                        <asp:Literal ID="Literal11" runat="server" Text="<%$Resources:WallBoard, Queue_DroppedByQMCalls%>"/>
                    </p>
                </td>
                <td ID="DroppedByQMCalls" align="center">
                    <asp:Label ID="Label12" class="droppedByQMCalls" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.TotalTalkTime.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P8" class="captionLabel">
                        <asp:Literal ID="Literal12" runat="server" Text="<%$Resources:WallBoard, Queue_TotalTalkTime%>"/>
                    </p>
                </td>
                <td ID="TotalTalkTime" align="center">
                    <asp:Label ID="Label13" class="totalTalkTime" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.LongestWaitTime.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P9" class="captionLabel">
                        <asp:Literal ID="Literal13" runat="server" Text="<%$Resources:WallBoard, Queue_LongestWaitTime%>"/>
                    </p>
                </td>
                <td ID="LongestWaitTime" align="center">
                    <asp:Label ID="Label14" class="longestWaitTime" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.AvTalkTime.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P10" class="captionLabel">
                        <asp:Literal ID="Literal14" runat="server" Text="<%$Resources:WallBoard, Queue_AvTalkTime%>"/>
                    </p>
                </td>
                <td ID="AvTalkTime" align="center">
                    <asp:Label ID="Label15" class="avTalkTime" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
            <tr <% if(!queue.AbandonRate.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P11" class="captionLabel">
                        <asp:Literal ID="Literal15" runat="server" Text="<%$Resources:WallBoard, Queue_AbandonRate%>"/>
                    </p>
                </td>
                <td ID="AbandonRate" align="center">
                    <asp:Label ID="Label16" class="abandonRate" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                    <b class="abandonRate">
                        <% if (IsCCE) Response.Write("&nbsp;%"); %>
                    </b>
                </td>
            </tr>
            
            <tr <% if(!queue.TotalUserRequestedEnd.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P13" class="captionLabel">
                        <asp:Literal ID="Literal17" runat="server" Text="<%$Resources:WallBoard, Queue_TotalUserRequestedEnd%>"/>
                    </p>
                </td>
                <td ID="TotalUserRequestedEnd" align="center">
                    <asp:Label ID="Label18" class="totalUserRequestedEnd" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
			
			<tr <% if(!queue.TotalCallsReachedMaxTime.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P12" class="captionLabel">
                        <asp:Literal ID="Literal16" runat="server" Text="<%$Resources:WallBoard, Queue_TotalCallsReachedMaxTime%>"/>
                    </p>
                </td>
                <td ID="TotalCallsReachedMaxTime" align="center">
                    <asp:Label ID="Label17" class="totalCallsReachedMaxTime" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>
			
            <tr <% if(!queue.TotalTransfersFailed.IsVisible) Response.Write("style=display:none");%>>
                <td>
                    <p id="P14" class="captionLabel">
                        <asp:Literal ID="Literal18" runat="server" Text="<%$Resources:WallBoard, Queue_TotalTransfersFailed%>"/>
                    </p>
                </td>
                <td ID="TotalTransfersFailed" align="center">
                    <asp:Label ID="Label19" class="totalTransfersFailed" runat="server" Text="0">
                        <% if (!IsCCE) Response.Write(CCEMessage); %>
                    </asp:Label>
                </td>
            </tr>

			<tr id="messageBoardRow">
                <td class="menuHeader" align="left" colspan="2">
                    <div id="messageBoard"></div>                
                </td>
            </tr>

        </table>

</asp:Content>
