using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.IO;

public partial class SaveRecording : System.Web.UI.Page
{
    public static String basePath = @"C:\Program Files\3CX PhoneSystem\Data\Ivr\Voicemail\Extensions\";

    protected void Page_Load(object sender, EventArgs e)
    {
        //
        // save audio file
        //
        String fname = Request.Params.Get("fname");
        String folder = Request.Params["folder"];
        if (folder == null)            folder = "";
        basePath = Utils.GetVoicemailPath();

        String err_msg = null;
        try
        {
            String path = Path.GetFullPath(basePath + @"\" + folder);
            System.IO.Directory.CreateDirectory(path);

            HttpPostedFile f = Request.Files.Get("msg");
            f.SaveAs( Path.Combine(path, fname) );
        }
        catch(Exception ex)
        {
            err_msg = ex.Message;
        }

        //
        // create vxml output
        //
        XmlDocument doc = new XmlDocument();
        XmlNode vxml = doc.CreateElement("vxml");
        doc.AppendChild(vxml);

        Utils.AddAttr(vxml, "version", "2.0");
        Utils.AddAttr(vxml, "application", "root.vxml");

        XmlNode form = doc.CreateElement("form");
        vxml.AppendChild(form);

        XmlNode blk = doc.CreateElement("block");
        form.AppendChild(blk);

        
        if (err_msg != null)
        {
            XmlNode log = doc.CreateElement("log");
            blk.AppendChild(log);
            log.InnerText = err_msg;
        }

        //XmlNode prm = doc.CreateElement("prompt");
        //blk.AppendChild(prm);
        //Utils.AddAttr(prm, "bargein", "false");
        //Utils.AddAttr(prm, "timeout", "1ms");

        XmlNode ret = doc.CreateElement("return");
        blk.AppendChild(ret);

        Response.Buffer = true;
        Response.BufferOutput = true;
        Response.Expires = 0;
        Response.Cache.SetNoStore();
        Response.Clear();
        //Response.AddHeader("Connection", "close");

        doc.Save(Response.OutputStream);
        doc.Save(Console.Out);
        //Response.Flush();
    }
}
