
    // SMDR formating example
    // for Mitel SX2000 specifically for Call Accounting Mate S/w

    StringBuilder ret = new StringBuilder();
    ret.EnsureCapacity(250);

    foreach(DetailData3 dd in details)
    {
        // Long Call
        try
        {
            TimeSpan duration = (dd.EndTime - dd.StartTime); //(int)callinfo.tmDuration.TotalMinutes;
            int minutes = (int)((TimeSpan)duration).TotalMinutes; //(int)callinfo.tmDuration.TotalMinutes;
            if (minutes < 5)        ret.Append(" ");
            else if (minutes < 10)  ret.Append("-");
            else if (minutes < 30)  ret.Append("%");
            else                    ret.Append("*");

            // date time 
            DateTime dt = dd.StartTime;
            if (dt.Hour > 11)
            {
                dt.AddHours(-12);
                ret.Append(dt.ToString("MM/dd HH:mm"));
                ret.Append("p ");
            }
            else
            {
                ret.Append(dt.ToString("MM/dd HH:mm"));
                ret.Append("  ");
            }

            // duration
            ret.AppendFormat("{0:HH:mm:ss} ", new DateTime(((TimeSpan)callinfo.tmDuration).Ticks));

            // Calling Party
            //if (callinfo.sLineNum == callinfo.sCallTo)
            //    ret += "T" + callinfo.sLineNum.Substring(Math.Max(4,callinfo.sLineNum.Length));
            //else
            int trim = Math.Max(0, callinfo.sCallerID.Length - 4);
            ret.AppendFormat("{0,-4}",callinfo.sCallerID.Substring(trim));
            ret.Append(" ");

            // Attendant
            //
            if (dd.ParentIdx > -1) ret.Append("*");// attendant
            else ret.Append(" ");// attendant not involved

            // Time to answer
            if (dd.AnswerTime != null && dd.AnswerTime.Ticks > 0)
            {
                TimeSpan ringtime = dd.AnswerTime - dd.StartTime;
                ret.AppendFormat("{0:D3} ", Convert.ToInt32(ringtime.TotalSeconds));
            }
            else
                ret.Append("*** ");

            // Digits dialed
            trim = Math.Max(0, dd.DestNum.Length - 15);
            ret.AppendFormat("{0,-15}", dd.DestNum.Substring(trim)); ret.Append(" ");

            // Meter Pulses

            // Call completion status
            String ccstat = "  ";
            //int last = details.Count-1;
            if (dd.ParentIdx>-1) ccstat = "A ";
            else if (dd.Status == cnStatus.DestBusy) ccstat = "B ";
            else if ((dd.Status > cnStatus.DestBusy) &&
                     (dd.Status != cnStatus.Completed)) ccstat = "E ";
            else if (callinfo.sBillPrefix.Length < 1) ccstat = "T ";
            else if (!dd.bCallToOutside) ccstat = "I ";
            ret.Append(ccstat);

            // Speed Call
            ret.Append("F ");

            ret.Append("        ");
            // trunk/line
            trim = Math.Max(0, callinfo.sLineNum.Length - 4);
            ret.AppendFormat("{0,-4}",callinfo.sLineNum.Substring(trim));
            ret.Append(" ");



            // called party
            //ret.Append(dd.DestNum); ret.Append(" "); 
            trim = Math.Max(0, dd.DestDN.Length - 3);
            ret.AppendFormat("{0,3}", dd.DestDN.Substring(trim));
            ret.Append(" ");
            
            // Transfer/confenrence call
            ret.Append("T ");

            // MCD Transfered calls

            // Third Party
            //ret.Append("         ");

            // Account code
            ret.Append(callinfo.sBillPrefix);   ret.Append(" "); 

            // Route Optimization flag

            // System identifier

            // Autovon call priority level

            // ANI/DNIS

            // Duration of call


            // Digits Dialed on the Trunk

            // transfered to 000
        }
        catch (Exception e)
        { Log.Exception(e);  }
        ret.Append("\r\n");
    }

    return ret.ToString();
