<%@ Page Language="C#" EnableSessionState="false" %>
<%@ Import Namespace="System" %>
<%@ Import Namespace="System.Configuration" %>
<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Web" %>
<%@ Import Namespace="System.Web.Security" %>
<%@ Import Namespace="System.Web.UI" %>
<%@ Import Namespace="System.Web.UI.WebControls" %>
<%@ Import Namespace="System.Web.UI.WebControls.WebParts" %>
<%@ Import Namespace="System.Web.UI.HtmlControls" %>


<script runat="server">

  private void validateProjectName(string projectName)
  {
    if (projectName.Contains("/") || projectName.Contains(@"\") || projectName.Split('_').Length < 2)
      throw new ArgumentException("projectname is invalid");
  }
  
  private void Page_Load(object sender, EventArgs e)
  {
    Response.Cache.SetNoStore();
    
    try
    {
      string projectName = Request.QueryString["projectname"];
      validateProjectName(projectName);
      
      List<string> fileNameList = new List<string>();
      DirectoryInfo projectDirectoryInfo = new DirectoryInfo(Server.MapPath(projectName));
      if (projectDirectoryInfo.Exists)
      {
        foreach (FileInfo fileInfo in projectDirectoryInfo.GetFiles("*.DebugInfo", SearchOption.TopDirectoryOnly))
          fileNameList.Add(fileInfo.Name);
        
        Response.Write(String.Join("\n", fileNameList.ToArray()));
      }
    }
    catch (Exception exc)
    {
      Response.Write("ERROR: " + exc.Message);
    }
  }
  
</script>
