using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Xml;
using System.Text;

public partial class SaveAudio : System.Web.UI.Page
{
    public static string gPathToData = @"C:\Program Files\3CX PhoneSystem\Data";

    protected void Page_Load(object sender, EventArgs e)
    {
        String ext = Request.Params["ext"];
        String fname = Request.Params["file"];
        HttpPostedFile p_file = Request.Files.Get("msg");

        while (p_file.InputStream.Length < p_file.ContentLength)
        {
            Response.Flush();
        }

        XmlDocument doc = Utils.CreateVxml();
        XmlNode vxml = doc.FirstChild;

        //add form
        XmlNode form = doc.CreateElement("form");
        vxml.AppendChild(form);
        Utils.AddAttr(form, "id", "frmSaveAudio");

        XmlNode saved = doc.CreateElement("var");
        form.AppendChild(saved);
        Utils.AddAttr(saved, "name", "saved");
        Utils.AddAttr(saved, "expr", "0");

        XmlNode blk = doc.CreateElement("block");
        form.AppendChild(blk);

        //check incoming params
        if (ext == null || fname == null || p_file == null || p_file.ContentLength == 0)
            goto Exit;

        if(ext =="")
        {
            try
            {
                String path = Path.GetDirectoryName(fname);
                Directory.CreateDirectory(path);

                p_file.SaveAs(fname);
                saved.Attributes["expr"].Value = "1";
            }
            catch (Exception)
            {
            }
            goto Exit;
        }
        if (!fname.StartsWith("/Ivr/Voicemail/"))
            goto Exit;

        try
        {
            //fname = @"C:\Program Files\3CX PhoneSystem\Data" + fname;
            string basePath = Utils.GetVoicemailPath();
            basePath = Path.GetFullPath(Path.Combine(basePath, @"..\..\"));
            fname = fname.Replace('/', '\\');
            fname = Path.Combine(basePath, @"." + fname);

            String path = Path.GetDirectoryName(fname);
            Directory.CreateDirectory(path);

            p_file.SaveAs(fname);
            saved.Attributes["expr"].Value = "1";
        }
        catch (Exception)
        {
        }

    Exit:
        XmlNode retN = doc.CreateElement("return");
        blk.AppendChild(retN);
        Utils.AddAttr(retN, "namelist", "saved");

        Response.Buffer = true;
        Response.Charset = "utf-8";
        Response.BufferOutput = true;
        Response.Expires = 0;
        Response.Cache.SetNoStore();
        Response.Clear();
        //Response.AddHeader("Content-Length", doc.OuterXml.Length.ToString());

        doc.Save(Response.OutputStream);
        doc.Save(Console.Out);
        //Response.Flush();     // DON'T DO IT after POST command!!
    }
}
