﻿<%@ Page Title="<%$Resources:WallBoard, Login_Title%>" Language="C#" MasterPageFile="~/Login.master" AutoEventWireup="true"
    CodeBehind="Login.aspx.cs" Inherits="WallBoard.Account.Login" %>

<%@ Register Assembly="WallBoard" namespace="WallBoard.CustomControls" tagprefix="uc" %>  

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="../Scripts/jquery-1.4.1.min.js" type="text/javascript"></script>
    <script type="text/javascript">

        // Page was successfully loaded
        $(document).ready(function () {

            // Center MainContent_LoginUser table
            $('#MainContent_LoginUser').attr("align", "center");

        });

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Login ID="LoginUser" runat="server" 
        onauthenticate="UserLogin_Authenticate">
        <LayoutTemplate>
            <span class="failureNotification">
                <asp:Literal ID="FailureText" runat="server"></asp:Literal>
            </span>
            <%--<asp:ValidationSummary ID="LoginUserValidationSummary" runat="server" CssClass="failureNotification" 
                 ValidationGroup="LoginUserValidationGroup"/>--%>
            <uc:CustomValidationSummary ID="LoginUserValidationSummary" runat="server" 
                    CssClass="failureNotification" ValidationGroup="LoginUserValidationGroup"/>
            <div class="accountInfo">
               <fieldset class="login">
                  <legend><asp:Literal ID="Literal1"  runat="server" Text="<%$Resources:WallBoard, Login_PleaseLogin%>"/></legend>
                    <div class="center">
                        <table>
                        <tr>
                            <td>
                                <asp:Label ID="UserNameLabel" runat="server" AssociatedControlID="UserName" Text="<%$Resources:WallBoard, Login_Username%>"></asp:Label>
                                <asp:TextBox ID="UserName" runat="server" CssClass="textEntry"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="UserNameRequired" runat="server" ControlToValidate="UserName" 
                                     CssClass="failureNotification" ErrorMessage="<%$Resources:WallBoard, Login_UsernameRequired%>" ToolTip="<%$Resources:WallBoard, Login_UsernameRequired%>" 
                                     ValidationGroup="LoginUserValidationGroup">*</asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="PasswordLabel" runat="server" AssociatedControlID="Password" Text="<%$Resources:WallBoard, Login_Password%>"></asp:Label>
                                <asp:TextBox ID="Password" runat="server" CssClass="passwordEntry" 
                                    TextMode="Password" ViewStateMode="Enabled"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="PasswordRequired" runat="server" ControlToValidate="Password" 
                                     CssClass="failureNotification" ErrorMessage="<%$Resources:WallBoard, Login_PasswordRequired%>" ToolTip="<%$Resources:WallBoard, Login_PasswordRequired%>" 
                                     ValidationGroup="LoginUserValidationGroup">*</asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                            <asp:Label ID="QueueLabel" runat="server" AssociatedControlID="Queue" Text="<%$Resources:WallBoard, Login_Queue%>"></asp:Label>
                            <asp:DropDownList ID="Queue" runat="server" CssClass="dropDownListEntry"></asp:DropDownList>
                            <asp:RequiredFieldValidator ID="QueueRequired" runat="server" ControlToValidate="Queue" 
                                 CssClass="failureNotification" ErrorMessage="<%$Resources:WallBoard, Login_QueueRequired%>" ToolTip="<%$Resources:WallBoard, Login_QueueRequired%>" 
                                 ValidationGroup="LoginUserValidationGroup">*</asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="LanguageLabel" runat="server" AssociatedControlID="LanguageDropDown">
                                    <asp:Literal ID="CallsWaitingLiteral" runat="server" Text="<%$Resources:WallBoard, Login_Language%>"/>
                                </asp:Label>
                                <asp:DropDownList ID="LanguageDropDown" CssClass="dropDownLanguage" runat="server" AutoPostBack="True">
                                    <asp:ListItem Value="en-US" Text="<%$Resources:WallBoard, Login_Language_English%>"></asp:ListItem>
                                    <asp:ListItem Value="fr-FR" Text="<%$Resources:WallBoard, Login_Language_French%>"></asp:ListItem>
                                    <asp:ListItem Value="es-ES" Text="<%$Resources:WallBoard, Login_Language_Spanish%>"></asp:ListItem>
                                    <asp:ListItem Value="it-IT" Text="<%$Resources:WallBoard, Login_Language_Italian%>"></asp:ListItem>
                                    <asp:ListItem Value="ru-RU" Text="<%$Resources:WallBoard, Login_Language_Russian%>"></asp:ListItem>
                                    <asp:ListItem Value="da-DK" Text="<%$Resources:WallBoard, Login_Language_Danish%>"></asp:ListItem>
                                    <asp:ListItem Value="el-GR" Text="<%$Resources:WallBoard, Login_Language_Greek%>"></asp:ListItem>
                                    <asp:ListItem Value="de-DE" Text="<%$Resources:WallBoard, Login_Language_German%>"></asp:ListItem>
                                    <asp:ListItem Value="cs-CZ" Text="<%$Resources:WallBoard, Login_Language_Czech%>"></asp:ListItem>
                                    <asp:ListItem Value="zh-CN" Text="<%$Resources:WallBoard, Login_Language_Chinese%>"></asp:ListItem>
                                    <asp:ListItem Value="nl-NL" Text="<%$Resources:WallBoard, Login_Language_Dutch%>"></asp:ListItem>
                                </asp:DropDownList>

                                <span>
                                    <asp:CheckBox ID="RememberMe" runat="server"/>
                                    <asp:Label ID="RememberMeLabel" runat="server" AssociatedControlID="RememberMe" CssClass="rememberMeLabel" Text="<%$Resources:WallBoard, Login_RememberMe%>"></asp:Label>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p class="submitButton">
                                    <asp:Button ID="LoginButton" runat="server" CommandName="Login" Text="<%$Resources:WallBoard, Login_Login%>" ValidationGroup="LoginUserValidationGroup"/>
                                </p>
                             </td>
                        </tr>
                        </table>
                    </div>
                </fieldset>

                <div class="loginInfo">
                    <asp:Literal ID="InfoWallBoardContent" runat="server" Text="<%$Resources:WallBoard, LoginInfo_Content%>"/>
                    <asp:Hyperlink id="InfoWallBoardHyperlink" Target="_new" NavigateUrl="<%$Resources:WallBoard, WallBoard_Blog%>" Text="<%$Resources:WallBoard, LoginInfo_Here%>" runat="server"/>.
                </p>
            </div>
        </LayoutTemplate>
    </asp:Login>
</asp:Content>
