<%@ Page Language="C#" EnableSessionState="false" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Web" %>
<%@ Import Namespace="System.Web.Security" %>
<%@ Import Namespace="System.Web.UI" %>
<%@ Import Namespace="System.Web.UI.WebControls" %>
<%@ Import Namespace="System.Web.UI.WebControls.WebParts" %>
<%@ Import Namespace="System.Web.UI.HtmlControls" %>


<script runat="server">

  private void validateProjectName(string projectName)
  {
    if (projectName.Contains("/") || projectName.Contains(@"\") || projectName.Split('_').Length < 2)
      throw new ArgumentException("projectname is invalid");
  }

  private void validateFileName(string fileName)
  {
    if (!fileName.EndsWith(".DebugInfo"))
      throw new ArgumentException("filename is invalid");
  }
  
  private void Page_Load(object sender, EventArgs e)
  {
    Response.Cache.SetNoStore();
    
    try
    {
      string projectName = Request.QueryString["projectname"];
      string fileName = Request.QueryString["filename"];
      validateProjectName(projectName);
      validateFileName(fileName);
      
      Response.Write(File.ReadAllText(Server.MapPath(projectName + @"\" + fileName)));
    }
    catch (Exception)
    {
    }
  }
  
</script>
